/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.services.PluginSourceService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PluginSourceDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 450;
    private Manifest manifest = null;
    private PluginSource choosen = null;

    public PluginSourceDialog(int position, Manifest mf) {
        super(position);
        this.manifest = mf;
        this.setSize(450, -1);
        if (this.manifest != null) {
            this.setTitle(this.i18n.tr("Plugin \"{0}\" installieren in...", this.manifest.getName()));
        } else {
            this.setTitle(this.i18n.tr("Plugins installieren in..."));
        }
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent, true);
        if (this.manifest != null) {
            c.addText(this.i18n.tr("Bitte w\u00e4hlen Sie den Ordner, in dem das Plugin \"{0}\" installiert werden soll.", this.manifest.getName()), true);
        } else {
            c.addText(this.i18n.tr("Bitte w\u00e4hlen Sie den Ordner, in dem die Plugins installiert werden sollen."), true);
        }
        final LabelInput dir = new LabelInput("");
        dir.setColor(Color.COMMENT);
        dir.setName("");
        PluginSourceService service = (PluginSourceService)Application.getBootLoader().getBootable(PluginSourceService.class);
        final SelectInput select = new SelectInput(service.getWritableSources(), (Object)service.getDefault());
        select.setAttribute("name");
        select.setName(this.i18n.tr("Plugin-Ordner"));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                PluginSource s = (PluginSource)select.getValue();
                dir.setValue(s.getDir().toString());
            }
        };
        select.addListener(l);
        l.handleEvent(null);
        c.addInput(select);
        c.addInput(dir);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.i18n.tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                PluginSourceDialog.this.choosen = (PluginSource)select.getValue();
                PluginSourceDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(this.i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(450, -1));
    }

    protected Object getData() throws Exception {
        return this.choosen;
    }
}

